'
' Klasa LexicalAnalyzer definiuje logik zwizan z wykonywaniem analizy
' leksykalnej dla naszego jzyka kombinacji wyrazw.
'
Public Class LexicalAnalyzer
    Private cur As Integer = -1
    Private input As System.IO.TextReader
    Private lastToken As Id
    Private tokenString As String
    Private Shared ReadOnly whitespaceRegex As Regex = New Regex("\G[ ]*")
    Private Shared ReadOnly orRegex As Regex _
        = New Regex("\Gor\b", RegexOptions.IgnoreCase)
    Private Shared ReadOnly andRegex As Regex _
        = New Regex("\Gand\b", RegexOptions.IgnoreCase)
    Private Shared ReadOnly nearRegex As Regex _
        = New Regex("\Gnear\b", RegexOptions.IgnoreCase)
    Private Shared ReadOnly notRegex As Regex _
        = New Regex("\Gnot\b", RegexOptions.IgnoreCase)
    Private Shared ReadOnly quotedStringRegex As Regex _
        = New Regex("\G""([^""]*("""")*)*""", RegexOptions.IgnoreCase)
    Private Shared ReadOnly wordRegex As Regex = New Regex("[a-z0-9]+")

    ' Stae identyfikujce typy ostatnio rozpoznanych tokenw.
    Public Enum Id
        ' Znaleziono niespodziewany znak.
        InvalidChar = -1
        ' Nie rozpoznano jeszcze adnego tokenu.
        NoToken = 0
        ' Token Or
        [Or] = 1
        ' Token And
        [And] = 2
        ' Token Near
        Near = 3
        ' Token Not
        [Not] = 4
        ' Token Word
        Word = 5
        ' Token lewego nawiasu
        LeftParen = 6
        ' Token prawego nawiasu
        RightParen = 7
        ' Token acucha w cudzysowie
        QuotedString = 8
        ' Koniec pliku
        Eof = 9
    End Enum 'Id

    ' Konstruktor
    ' r - Strumie strumie wejciowy zawierajcy dane wejciowe bdce przedmiotem
    '     analizy leksykalnej.
    Public Sub New(ByVal r As System.IO.TextReader)
        input = r
    End Sub

    '
    ' acuch rozpoznany jako token wyrazu lub wntrze (ciao) acucha w cudzysowie.
    '
    Public ReadOnly Property StringValue() As String
        Get
            Return tokenString
        End Get
    End Property

    Private line As String = Nothing

    Private Sub ResetStrs()
        line = input.ReadLine()
        cur = 0
    End Sub

    '
    ' Zwraca typ nastpnego tokenu. W przypadku tokenw wyrazw i acuchw
    ' w cudzysowach istnieje moliwo uzyskiwania reprezentowanych acuchw
    ' za porednictwem metody getString.
    '
    Public Function NextToken() As Id
        Dim m As Match
        Do
            If strs Is Nothing Then
                ResetStrs()
            Else If
            If line Is Nothing Then
                lastToken = Id.Eof
                Return Id.Eof
            End If
            m = whitespaceRegex.Match(line, cur)
            cur += m.Length
        Loop While cur >= line.Length

        m = orRegex.Match(line, cur)
        If m.Success Then
            lastToken = Id.Or
            tokenString = m.Value
            cur += m.Length
            Return lasttok
        End If

        m = andRegex.Match(line, cur)
        If m.Success Then
            lastToken = Id.And
            tokenString = m.Value
            cur += m.Length
            Return lasttok
        End If

        m = nearRegex.Match(line, cur)
        If m.Success Then
            lastToken = Id.Near
            tokenString = m.Value
            cur += m.Length
            Return lasttok
        End If

        m = notRegex.Match(line, cur)
        If m.Success Then
            lastToken = Id.Not
            tokenString = m.Value
            cur += m.Length
            Return lasttok
        End If

        If line(cur) = "("c Then
            lastToken = Id.LeftParen
            tokenString = "("
            cur += 1
            Return Id.LeftParen
        End If

        If line(cur) = ")"c Then
            lastToken = Id.RightParen
            tokenString = ")"
            cur += 1
            Return Id.RightParen
        End If

        m = quotedStringRegex.Match(line, cur)
        If m.Success Then
            lastToken = Id.QuotedString
            tokenString = m.Value
            cur += m.Length
            Return lasttok
        End If

        m = wordRegex.Match(line, cur)
        If m.Success Then
            lastToken = Id.Word
            tokenString = m.Value
            cur += m.Length
            Return lasttok
        End If

        ' Nie udao si znale adnego oczekiwanego tokenu.
        lastToken = Id.NoToken
        tokenString = line.Substring(cur)
        cur = line.Length
        Return lastToken
    End Function 'NextToken
End Class 'LexicalAnalyzer
